//
// Generated by JTB GJ1.1
//

package visitor;
import syntaxtree.*;
import java.util.Enumeration;
import value.* ;
import java.lang.Integer ;

/**
 * Provides default methods which visit each node in the tree in depth-first
 * order.  Your visitors may extend this class.
 */
public class GJPigletInterpreter extends GJDepthFirst<PGValue,Node> {
   //
   // Auto class visitors--probably don't need to be overridden.
   //

    public static PGValue[] TPV = new PGValue[10000] ;
    //public static int[] TP = new int[10000] ; //array to store temps
    public static PGValue[] HEAP = new PGValue[10000] ; //heap array

    // NOTE: bug fixed 20071029 by jurgens@cs
    //
    // This previously started the heap pointer at 0, which caused
    // confusion when performing null checks.  The heap pointer is now
    // initialized to 1.
    public static int HP = 1 ;

    private boolean stop ;
    private boolean start ;
    private String met_name ;
    private String label_name ;
    private Node pg_root ;
    private int last_tp_index ;

    public void Print(){
	System.out.println("################################");
	for(int i = 0 ; i < HP ; i++){
	    System.out.print("HP["+i+"] = ");
	    if (HEAP[i] != null){
		if (HEAP[i] instanceof Label_pg)
		    System.out.print(HEAP[i].GetLabel() + "\t\t");
		else System.out.print(HEAP[i].GetVal() + "\t\t");} 
	    else System.out.print("null \t\t");
	    
	    System.out.print("TP["+i+"] = ");
	    if (TPV[i] != null) 
		if (TPV[i] instanceof Label_pg)
		    System.out.println(TPV[i].GetLabel() + "\t"); 
		else System.out.println(TPV[i].GetVal() + "\t"); 
	    else System.out.println("null");
	}
	System.out.println("################################");
    }

    public GJPigletInterpreter(String name, PGValue[] arg_list, Node r){
	stop = false ;
	start = true ;
	last_tp_index = 0 ;
	met_name = name ;
	pg_root = r ;
	if (arg_list != null)
	    for(int i = 0 ; i < arg_list.length ; i++)
		TPV[i] = arg_list[i];
		//TP[i] = arg_list[i].GetVal();
    }


   public PGValue visit(NodeList n,Node argu) {
      PGValue _ret=null;

      int _count=0;
      for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); ) {
         e.nextElement().accept(this,argu);
         _count++;
      }
      return _ret;
   }

   public PGValue visit(NodeListOptional n,Node argu) {
      ParamList_pg pl = new ParamList_pg();
      if ( n.present() ) {
         PGValue _ret=null;
         int _count = 0;
         for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); ) {
	     PGValue p = (PGValue) e.nextElement().accept(this,argu);
	     if (p != null) pl.Insert(p) ;
	     _count++;
         }
         return pl;
      }
      else
	  return null;
   }

   public PGValue visit(NodeOptional n, Node argu) {
      if ( n.present() )
         return n.node.accept(this,argu);
      else
         return null;
   }

   public PGValue visit(NodeSequence n, Node argu) {
      PGValue _ret=null;
      int _count=0;
      for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); ) {
	     PGValue p = (PGValue) e.nextElement().accept(this,argu);
         _count++;
      }
      return _ret;
   }

   public PGValue visit(NodeToken n, Node argu) { return null; }

   //
   // User-generated visitor metahods below
   //

   /**
    * f0 -> "MAIN"
    * f1 -> StmtList()
    * f2 -> "END"
    * f3 -> ( Procedure() )*
    * f4 -> <EOF>
    */
   public PGValue visit(Goal n, Node argu) {
      PGValue _ret=null;
      ParamList_pg pl ;
      n.f0.accept(this, argu);
      if (met_name.equals("MAIN")) {
	  //System.out.println("MAIN");
	  n.f1.accept(this, n.f1);
	  return null ;
      }
      n.f2.accept(this, argu);
      pl = (ParamList_pg) n.f3.accept(this, argu);
      n.f4.accept(this, argu);
      return pl.GetFirst();
   }

   /**
    * f0 -> ( ( Label() )? Stmt() )*
    */
   public PGValue visit(StmtList n, Node argu) {
      PGValue _ret=null;
	  //System.out.println("STMLIST");
      n.f0.accept(this, argu);
      return _ret;
   }

   /**
    * f0 -> Label()
    * f1 -> "["
    * f2 -> IntegerLiteral()
    * f3 -> "]"
    * f4 -> StmtExp()
    */
   public PGValue visit(Procedure n, Node argu) {
      String aux ;
      PGValue _ret=null;
      String m_name = (n.f0).f0.toString() ;
      if (!(m_name.equals(met_name))) return null ;
      aux = met_name ;
      //System.out.println("PROC Name >> " + met_name);
      met_name = " " ;
      start = true ;
      stop = false ;
      n.f1.accept(this, n);
      n.f2.accept(this, n);
      n.f3.accept(this, n);
      _ret = n.f4.accept(this, n);
      //System.out.println("RETURN " + aux + " " + _ret.GetVal());
      
      return _ret;
   }

   /**
    * f0 -> NoOpStmt()
    *       | ErrorStmt()
    *       | CJumpStmt()
    *       | JumpStmt()
    *       | HStoreStmt()
    *       | HLoadStmt()
    *       | MoveStmt()
    *       | PrintStmt()
    */
   public PGValue visit(Stmt n, Node argu) {
      if (stop) return null ;
      if (start) n.f0.accept(this, argu);
      return null;
   }

   /**
    * f0 -> "NOOP"
    */
   public PGValue visit(NoOpStmt n, Node argu) {
      PGValue _ret=null;
      //System.out.println("NOOP");
      n.f0.accept(this, argu);
      return _ret;
   }

   /**
    * f0 -> "ERROR"
    */
   public PGValue visit(ErrorStmt n, Node argu) {
      System.out.println("ERROR");
      System.exit(1);
      return null;
   }

   /**
    * f0 -> "CJUMP"
    * f1 -> Exp()
    * f2 -> Label()
    */
   public PGValue visit(CJumpStmt n, Node argu) {
      PGValue p = n.f1.accept(this, argu) ;
      int cond  = 0;
      if (p == null) return null ;
      else cond = p.GetVal();
      if (cond == 1) return null ;
      String l_name = (n.f2.accept(this, argu)).GetLabel();
      label_name = l_name ;
      start = false ;
      stop = false ;
      //System.out.println("CJUMP " + l_name);
      argu.accept(this,argu) ;
      stop = true ;
      start = true ;
      return null;
   }

   /**
    * f0 -> "JUMP"
    * f1 -> Label()
    */
   public PGValue visit(JumpStmt n, Node argu) {
      String l_name = (n.f1.accept(this, argu)).GetLabel();
      label_name = l_name ;
      start = false ;
      stop = false ;
      //System.out.println("JUMP " + l_name);
      argu.accept(this,argu) ;
      stop = true ;
      start = true ;
      return null;
   }

   /**
    * f0 -> "HSTORE"
    * f1 -> Exp()
    * f2 -> IntegerLiteral()
    * f3 -> Exp()
    */
   public PGValue visit(HStoreStmt n, Node argu) {
      //System.out.println("HSTORE");
      int address = (n.f1.accept(this, argu)).GetVal();
      int offset  = (n.f2.accept(this, argu)).GetVal();
      PGValue value   = n.f3.accept(this, argu);
      HEAP[address + offset] = value ; 
      //if (value instanceof Label_pg)
      //  System.out.println("HSTORE " + address + " " + offset + " " + value.GetLabel());
      // else 
      //  System.out.println("HSTORE " + address + " " + offset + " " + value.GetVal());
      
      return null;
   }

   /**
    * f0 -> "HLOAD"
    * f1 -> Temp()
    * f2 -> Exp()
    * f3 -> IntegerLiteral()
    */
   public PGValue visit(HLoadStmt n, Node argu) {
      //int index    = (n.f1.accept(this, argu)).GetVal();
      n.f1.accept(this, argu);
      int l_index  = last_tp_index ;
      int address  = (n.f2.accept(this, argu)).GetVal();
      int offset   = (n.f3.accept(this, argu)).GetVal();
      TPV[l_index] = (HEAP[address + offset]) ;
      //System.out.println("HLoad T" + l_index + " " + address + " " + offset + " <+++ " + TPV[l_index] );
      //TP[l_index] = (HEAP[address + offset]).GetVal() ;
      return null;
   }

   /**
    * f0 -> "MOVE"
    * f1 -> Temp()
    * f2 -> Exp()
    */
   public PGValue visit(MoveStmt n, Node argu) {
       //System.out.println("MOVE 1");
       n.f1.accept(this, argu);
       //System.out.println("MOVE TEMPPP " + last_tp_index);
       int l_index = last_tp_index ;
       PGValue exp = n.f2.accept(this, argu);
       //System.out.println("MOVE 3");
       TPV[l_index] = exp ; 
       //System.out.println("MOVE TEMP " + last_tp_index );
       //System.out.println("MOVE T" + l_index + "  " + exp);
       //int exp = (n.f2.accept(this, argu)).GetVal();
       //TP[l_index] = exp ;
       //if (exp instanceof Label_pg)
       //System.out.println("MOVE T" + l_index + "  " + exp.GetLabel());
       //else
       //System.out.println("MOVE T" + l_index + "  " + exp.GetVal());
       return null;
   }

   /**
    * f0 -> "PRINT"
    * f1 -> Exp()
    */
   public PGValue visit(PrintStmt n, Node argu) {
      PGValue _ret  = n.f1.accept(this, argu);
      System.out.println(_ret.GetVal());
      return null;
   }

     /**
    * f0 -> StmtExp()
    *       | Call()
    *       | HAllocate()
    *       | BinOp()
    *       | Temp()
    *       | IntegerLiteral()
    *       | Label()
    */
   public PGValue visit(Exp n, Node argu) {
      PGValue _ret  = n.f0.accept(this, argu);
      return _ret;
   }

   /**
    * f0 -> "BEGIN"
    * f1 -> StmtList()
    * f2 -> "RETURN"
    * f3 -> Exp()
    * f4 -> "END"
    */
   public PGValue visit(StmtExp n, Node argu) {
      PGValue _ret=null;
      Node n_node = n.f1 ;
      n.f0.accept(this, argu);
      n.f1.accept(this, n.f1);
      n.f2.accept(this, argu);
      start = true ;
      stop = false ;
      _ret = n.f3.accept(this,argu);
      n.f4.accept(this, argu);
      return _ret;
   }

   /**
    * f0 -> Operator()
    * f1 -> Exp()
    * f2 -> Exp()
    */
   public PGValue visit(BinOp n, Node argu) {
      int exp1 ;
      int exp2 ;
      int exp3 = 0;
      String op = (n.f0.accept(this, argu)).GetLabel();
      exp1 = (n.f1.accept(this, argu)).GetVal();
      exp2 = (n.f2.accept(this, argu)).GetVal();
      //System.out.println("BINOP ");
      if (op.equals("PLUS")) exp3 = exp1 + exp2 ;
      else if (op.equals("MINUS")) exp3 = exp1 - exp2 ;
      else if (op.equals("TIMES")) exp3 = exp1 * exp2 ;
      else if (op.equals("DIV")) {
          if (exp2 != 0) {
              exp3 = exp1 / exp2;
          } else {
              System.out.println("ERROR");
              System.exit(1);
          }
      }
      else if (op.equals("LE")) {
	  if (exp1 <= exp2) exp3 = 1 ;
	  else exp3 = 0 ; }
      else if (op.equals("NE")) {
	  if (exp1 != exp2) exp3 = 1 ;
	  else exp3 = 0 ; }
      else if (op.equals("AND")) {
	  if ((exp1 == 1) &  (exp2 == 1)) exp3 = 1 ;
	  else exp3 = 0 ; }
      return new Const(exp3);
   }

   /**
    * f0 -> "AND"
    *       | "LT"
    *       | "PLUS"
    *       | "MINUS"
    *       | "TIMES"
    */
   public PGValue visit(Operator n, Node argu) {
      return new Op(((n.f0).choice).toString());
   }

   /**
    * f0 -> "CALL"
    * f1 -> Exp()
    * f2 -> "("
    * f3 -> ( Exp() )*
    * f4 -> ")"
    */
   public PGValue visit(Call n, Node argu) {

      // NOTE: bug fix by jurgens@cs 10/30/07, kgo@cs 11/14/07
      // 
      // details: local_arg_size was previously initialized to 20.
      // This resulted in TEMP values being overwritten by the caller.
      // For recursive calls, the overwritten values were bugs if any
      // thing stored in an overwritten temp was used after the
      // recursive call.  For this reason, we now make a copy of the
      // entire temp space before each call.

      n.f0.accept(this, argu);

      PGValue function_addr = n.f1.accept(this, argu) ;

      if (!(function_addr instanceof Label_pg)) {
         System.err.println("error in CALL");
         System.exit(0);
         return null; // Will never actually be reached.
      }

      String m_name = function_addr.GetLabel();

      n.f2.accept(this, argu);

      // Caller saves all local variables.
      PGValue[] saved_locals = new PGValue[TPV.length];
      System.arraycopy(TPV, 0, saved_locals, 0, TPV.length);

      // Copy call args into first N temps.
      ParamList_pg pl = (ParamList_pg) n.f3.accept(this, argu);

      // NOTE: we save and return the TEMPs for the caller, so we are
      // free to update the TPV array at this point.  kgo@cs fixed a
      // bug where this statement caused the callee to have TPV
      // side-effects for the caller.

      // NOTE: that if the method had no parameters, pl will be null.
      // This bug was discovered by Prof. Todd Millstein todd@cs.

      // check to see if the callee has any arguments and if so, pass
      // them into the TPV temp array using the caller's parameters
      if (pl != null) {
	  int num_params =  pl.GetVal();
	  PGValue[] param_list = pl.GetList() ;
	  
	  for(int i = 0 ; i < num_params ; i++){
	      TPV[i] = param_list[i];
	  }
      }

      n.f4.accept(this, argu);
      met_name = m_name ;
      boolean old_start = start ;
      boolean old_stop = stop ;
      start = true ;
      stop = false ;
      //System.out.println("No NO NO 222" + met_name);
      PGValue _ret = pg_root.accept(this,pg_root);
      //System.out.println("No NO NO");
      start = old_start ;
      stop = old_stop ;

      // Restore saved local variables.
      TPV = saved_locals;

      return _ret;
   }

   /**
    * f0 -> "HALLOCATE"
    * f1 -> Exp()
    */
   public PGValue visit(HAllocate n, Node argu) {
      int old_hp = HP ;
      PGValue exp ;
      n.f0.accept(this, argu);
      exp = n.f1.accept(this, argu);
      HP = HP + exp.GetVal();
      return new Const(old_hp);
   }

   /**
    * f0 -> "TEMP"
    * f1 -> IntegerLiteral()
    */
   public PGValue visit(Temp n, Node argu) {
      PGValue p ;
      int index = Integer.parseInt((n.f1).f0.toString()) ;
      last_tp_index = index ;
      p = TPV[index] ;
      return  p ;
      //return  new Temp_pg(TP[index]);
   }


   /**
    * f0 -> <INTEGER_LITERAL>
    */
   public PGValue visit(IntegerLiteral n, Node argu) {
      return new Const(Integer.parseInt(n.f0.toString()));
   }

   /**
    * f0 -> <IDENTIFIER>
    */
   public PGValue visit(Label n, Node argu) {
      String lname = n.f0.toString() ;
      if (!start && label_name.equals(lname) ) start = true ;
      return new Label_pg(lname);
   }

}
