#include <iostream>
#include <vector>
#include <sys/time.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "tree.h"
#include "hheap.h"

using namespace std;

// compile as g++ heap-huffman.cpp heap.cpp
// run as a.out < heap-huffman-input.txt

void pushIntoHeap(Heap &h, Tree &tt, int nelements) {
	ElementType e;

	for (int ii = 0; ii < nelements; ++ii) {
		cin >> e.data;
		e.data = -e.data;
		e.ptr = tt.createNode(-e.data);
		h.insert(e);	// convert maxheap to minheap.
	}

	h.print();
	cout << "The tree is " << (h.isHeap() ? "" : "NOT ") << "a heap.\n";
}
void huffman(Heap &hh, Tree &tt) {
	// assumes at least one element.
	PtrToNode root = NULL;

	while (hh.size() > 1) {
		ElementType eone = hh.deleteMax();
		PtrToNode none = eone.ptr;
		ElementType etwo = hh.deleteMax();
		PtrToNode ntwo = etwo.ptr;


		ElementType ejoin;
		ejoin.data = eone.data + etwo.data;
		ejoin.ptr = tt.createNode(ejoin.data);
		hh.insert(ejoin);	// not -ejoin.
		ejoin.ptr->addChild(none);
		ejoin.ptr->addChild(ntwo);
		root = ejoin.ptr;
	}
	// root contains the last join.
	tt.setRoot(root);
}
int main() {
	int nelements;
	cin >> nelements;

	Heap hh;
	Tree tt;

	pushIntoHeap(hh, tt, nelements);
	huffman(hh, tt);
	tt.printHuffman();

	return 0;
}
