#include <iostream>
#include <vector>
#include "tree.h"
#include "hheap.h"
using namespace std;

Heap::Heap(int maxN/* = 20 */) {
	this->maxN = maxN;
	elements = new ElementType[maxN];
	nelements = 0;
}
int Heap::percolateUp(int ii) {
	int iiancestor = getParent(ii);
	ElementType e = elements[ii];	// important.

	while (iiancestor && e.data > elements[iiancestor].data) {	// for minheap, change > to <
		elements[ii] = elements[iiancestor];
		ii = iiancestor;
		iiancestor = getParent(ii);
	}

	return ii;	// new position.
}
int Heap::insert(ElementType e) {
	cout << "inserting " << e.data << endl;
	if (nelements + 1 == maxN) {
		cerr << "Heap overflow on inserting " << e.data << endl;
		return 0;
	}
	elements[++nelements] = e;	// insert at the end, index starts at 1.
	int ii = percolateUp(nelements);
	elements[ii] = e;		// finally insert at the right place.
	return ii;
}
int Heap::percolateDown(int iparent, bool checklast/* = true*/) {
	ElementType emax = elements[iparent];
	ElementType elast = elements[nelements];	// important.

	while (iparent < nelements) {
		int ileft = getLeft(iparent);
		int iright = getRight(iparent);

		ElementType eleftchild; eleftchild.data = NoElement;
		ElementType erightchild; erightchild.data = NoElement;
	
		if (ileft  <= nelements) eleftchild  = elements[ileft ];
		if (iright <= nelements) erightchild = elements[iright];

		// reverse the condition for minheap.
		if (!checklast && emax.data > eleftchild.data && emax.data > erightchild.data) break;

		if (eleftchild.data > erightchild.data && (!checklast || eleftchild.data > elast.data)) {	// left moves up
			cout << eleftchild.data << " moving to " << elements[iparent].data << ", iparent = " << ileft << " (from " << iparent << ")" << endl;
			elements[iparent] = eleftchild;
			iparent = ileft;
		} else if (eleftchild.data <= erightchild.data && (!checklast || erightchild.data > elast.data)) {	// right moves up.
			cout << erightchild.data << " moving to " << elements[iparent].data << ", iparent = " << iright << " (from " << iparent << ")" << endl;
			elements[iparent] = erightchild;
			iparent = iright;
		} else
			break;
	}

	return iparent;
}

ElementType Heap::deleteMax() {
	//if (nelements == 0) return NoElement;	// sentinel.

	cout << "deleting max...\n";
	ElementType emax = elements[1];
	ElementType elast = elements[nelements];
	int iparent = percolateDown(1);		// start from root.
	elements[iparent] = elast;
	--nelements;

	return emax;
}
bool Heap::isHeap(int ii) {	// checks for maxheap.
	if (ii <= nelements) {
		int iileft  = getLeft(ii);
		int iiright = getRight(ii);
		if (iileft  <= nelements && elements[ii].data < elements[iileft].data)  return false;
		if (iiright <= nelements && elements[ii].data < elements[iiright].data) return false;
	}
	return true;
}
bool Heap::isHeap() {
	for (int ii = 1; ii <= nelements / 2; ++ii)
		if (!isHeap(ii)) return false;
	return true;
}
bool isPowerOf2(int nn) {
	return !(nn & (nn - 1));
}
void Heap::print() {
	for (int ii = 1; ii <= nelements; ++ii) {
		cout << "\t" << elements[ii].data;

		if (isPowerOf2(ii + 1)) cout << endl;
	}
	cout << endl;
}
int Heap::size() {
	return nelements;
}
