
struct HeapNode {
	int data;
	PtrToNode ptr;
};
typedef struct HeapNode ElementType;

class Heap {
public:
	Heap(int maxN = 20);
	int insert(ElementType e);
	ElementType deleteMax();
	void print();
	int size();

	bool isHeap();
	bool isHeap(int ii);

private:
	int nelements, maxN;
	ElementType *elements;				// assumes unique elements.

	int percolateUp(int ii);
	int percolateDown(int ii, bool checklast = true);
	int getParent(int ii) { return ii / 2; }
	int getLeft(int ii) { return 2 * ii; }
	int getRight(int ii) { return 2 * ii + 1; }

	static const int NoElement = -999999;	// heap elements must be non-negative.
	static const int Infinity = 999999;
};


