#include <vector>
#include <iostream>

using namespace std;

typedef struct TreeNode *PtrToNode;
typedef int DataType;

struct TreeNode {
	DataType data;
	PtrToNode left, right;
	TreeNode(DataType data) {
		this->data = data;
		left = right = NULL;
	}
	void addChild(PtrToNode child) {
		if (!left) left = child;
		else right = child;
	}
	void print() {
		std::cout << data << std::endl;
	}
};
class Tree {
	PtrToNode root;
public:
	Tree():root(NULL) { }
PtrToNode createNode(DataType data) {
	PtrToNode ptr = new TreeNode(data);
	if (root == NULL) root = ptr;
	return ptr;
}
void setRoot(PtrToNode root) {
	this->root = root;
}
void printHuffman(PtrToNode root, string code) {
	if (root) {
		printHuffman(root->left, code + "0");
		printHuffman(root->right, code + "1");
		if (root->left == NULL && root->right == NULL)
			cout << root->data << ": " << code << endl;
	}
}
void printHuffman() {
	printHuffman(root, "");
}};


