// all bst operations.
#include <vector>
#include <iostream>
#include <string>

typedef struct TreeNode *PtrToNode;
typedef int DataType;

struct TreeNode {
	DataType data;
	PtrToNode left, right;
	TreeNode(DataType data);
	void addChild(PtrToNode);
	void print();
};
TreeNode::TreeNode(DataType data) {
	this->data = data;
	this->left = this->right = NULL;
}
void TreeNode::addChild(PtrToNode child) {
	// assume child != NULL.
	if (child->data < data) left = child;
	else right = child;
}
void TreeNode::print() {
	std::cout << data << " ";
}
class Tree {
	PtrToNode root;
public:
	Tree():root(NULL) { }
	void print();
	void inorder();
	void inorder(PtrToNode);
	PtrToNode insert(DataType val);
	PtrToNode insert(PtrToNode, PtrToNode);
	bool search(DataType data, PtrToNode rr);
	bool search(DataType data);
	DataType findmin();
	DataType findmin(PtrToNode);
	DataType findminiterative();
	PtrToNode findminptr(PtrToNode);
	PtrToNode remove(DataType);
	PtrToNode remove(DataType, PtrToNode);
	void printGraphviz();
	void printGraphviz(PtrToNode rr);
};

PtrToNode Tree::findminptr(PtrToNode rr) {
	if (rr && rr->left) return findminptr(rr->left);
	return rr;
}
DataType Tree::findmin(PtrToNode rr) {
	PtrToNode ptr = findminptr(rr);
	if (rr) return ptr->data;
	return -1;
}
DataType Tree::findmin() {
	return findmin(root);
}
DataType Tree::findminiterative() {
	PtrToNode ptr = root;
	if (ptr) {
		while (ptr->left) ptr = ptr->left;
		return ptr->data;
	}
	return -1;
}
PtrToNode Tree::insert(PtrToNode ptr, PtrToNode rr) {
	if (rr == NULL) return ptr;
	if (ptr->data < rr->data) rr->left = insert(ptr, rr->left);
	else rr->right = insert(ptr, rr->right);
}
PtrToNode Tree::insert(DataType data) {
	PtrToNode ptr = new TreeNode(data);
	root = insert(ptr, root);
	std::cout << "inserted " << data << std::endl;
	return ptr;
}
void Tree::inorder(PtrToNode rr) {
	if (rr) {
		inorder(rr->left);
		rr->print();
		inorder(rr->right);
	}
}
void Tree::inorder() {
	inorder(root);
	std::cout << std::endl;
}
void Tree::print() {
	inorder();
}
bool Tree::search(DataType data, PtrToNode rr) {
	if (rr == NULL) return false;
	if (data == rr->data) return true;
	if (data < rr->data) return search(data, rr->left);
	return search(data, rr->right);
}
bool Tree::search(DataType data) {
	bool present = search(data, root);
	if (present)
		std::cout << data << " present." << std::endl;
	else
		std::cout << data << " NOT present." << std::endl;
	return present;
}
void Tree::printGraphviz(PtrToNode rr) {
	if (rr) {
		if (rr->left) {
			std::cout << '"' << rr->data << '"';
			std::cout << " -> ";
			std::cout << '"' << rr->left->data << '"';
			std::cout << std::endl;
			printGraphviz(rr->left);
		}
		if (rr->right) {
			std::cout << '"' << rr->data << '"';
			std::cout << " -> ";
			std::cout << '"' << rr->right->data << '"';
			std::cout << std::endl;
			printGraphviz(rr->right);
		}
	}
}
PtrToNode Tree::remove(DataType data, PtrToNode rr) {
	if (rr == NULL)
		std::cout << "Element " << data << " NOT found.\n";
	else if (data < rr->data)
		rr->left = remove(data, rr->left);
	else if (rr->data < data)
		rr->right = remove(data, rr->right);
	else {	// the element is present in BST at rr.
		if (rr->left && rr->right) {	// scratch your head.
			PtrToNode minptr = findminptr(rr->right);
			rr->data = minptr->data;
			rr->right = remove(minptr->data, rr->right);
		} else {			// zero or one children.
			PtrToNode toberemoved = rr;
			if (rr->left == NULL)
				rr = rr->right;
			else
				rr = rr->left;
			delete toberemoved;	// free memory.
		}
	}
	
	return rr;
}
PtrToNode Tree::remove(DataType data) {
	std::cout << "removing " << data << std::endl;
	return remove(data, root);
}
void Tree::printGraphviz() {
	std::cout << "-----------------\n";
	std::cout << "digraph G {\n";
	printGraphviz(root);
	std::cout << "}\n";
	std::cout << "-----------------\n";
}
int main() {
	Tree t;
	std::cout << "	findmin = " << t.findmin() << std::endl;
	std::cout << "	fminite = " << t.findminiterative() << std::endl;
	t.insert(6);
	std::cout << "	findmin = " << t.findmin() << std::endl;
	std::cout << "	fminite = " << t.findminiterative() << std::endl;
	t.insert(8);
	std::cout << "	findmin = " << t.findmin() << std::endl;
	std::cout << "	fminite = " << t.findminiterative() << std::endl;
	t.insert(4);
	std::cout << "	findmin = " << t.findmin() << std::endl;
	std::cout << "	fminite = " << t.findminiterative() << std::endl;
	t.insert(2);
	std::cout << "	findmin = " << t.findmin() << std::endl;
	std::cout << "	fminite = " << t.findminiterative() << std::endl;
	t.insert(5);
	std::cout << "	findmin = " << t.findmin() << std::endl;
	std::cout << "	fminite = " << t.findminiterative() << std::endl;
	t.insert(1);
	std::cout << "	findmin = " << t.findmin() << std::endl;
	std::cout << "	fminite = " << t.findminiterative() << std::endl;
	t.insert(3);

	t.print();
	t.search(5);
	t.search(7);
	t.search(3);
	t.search(10);

	std::cout << "	findmin = " << t.findmin() << std::endl;
	std::cout << "	fminite = " << t.findminiterative() << std::endl;

	t.printGraphviz();

	/*
	Tree t2;
	t2.insert(4);
	t2.insert(8);
	t2.insert(2);
	t2.insert(6);
	t2.insert(5);
	t2.insert(1);
	t2.insert(3);
	t2.printGraphviz();
	t2.print();
	t2.remove(3);
	t2.print();
	t2.remove(8);
	t2.print();
	t2.remove(4);
	t2.print();
	*/

	/*
	Tree t3;
	t3.insert(8);
	t3.insert(6);
	t3.insert(5);
	t3.insert(4);
	t3.insert(3);
	t3.insert(2);
	t3.insert(1);
	t3.print();
	*/

	/*
	Tree t4;
	t4.insert(60);
	t4.insert(20);
	t4.insert(87);
	t4.insert(10);
	t4.insert(52);
	t4.insert(31);
	t4.insert(44);
	t4.print();
	t4.insert(50);
	t4.print();
	t4.insert(40);
	t4.print();
	t4.remove(20);
	t4.print();
	t4.insert(46);
	t4.print();
	t4.remove(31);
	t4.print();
	t4.remove(30);
	t4.print();
	t4.remove(60);
	t4.print();
	*/
}	

	
