#!/bin/bash

SOURCE="$1"

RED="\033[31m"
GREEN="\033[32m"
YELLOW="\033[33m"
BLUE="\033[34m"
RESET="\033[0m"

line() { printf '%*s\n' 48 '' | tr ' ' '-'; }

if [ -z "$SOURCE" ]; then
  echo "Usage: $0 <source.c>"
  exit 1
fi

if [ ! -f "$SOURCE" ]; then
  echo "Error: file not found: $SOURCE"
  exit 1
fi

BASENAME="${SOURCE%.*}"
EXECUTABLE="${BASENAME}.out"

line
echo -e "${BLUE}COMPILING:${RESET} $SOURCE -> $EXECUTABLE"

gcc "$SOURCE" -o "$EXECUTABLE" -lm
if [ $? -ne 0 ]; then
  echo -e "${RED}COMPILATION FAILED${RESET}"
  line
  exit 1
fi

rm -f tests/op_*

line
echo -e "${BLUE}TESTING:${RESET} $EXECUTABLE"

pass=0
fail=0
skip=0
total=0

shopt -s nullglob

for input_file in tests/ip_[0-9][0-9]; do
  total=$((total+1))

  expected_output="${input_file/ip_/ep_}"
  actual_output="${input_file/ip_/op_}"

  printf "%-44s" "$input_file"

  if [ ! -f "$expected_output" ]; then
    echo -e "${YELLOW}SKIP${RESET}"
    skip=$((skip+1))
    continue
  fi

  ./"$EXECUTABLE" < "$input_file" > "$actual_output"

  if diff -w -B "$actual_output" "$expected_output" > /dev/null; then
    echo -e "${GREEN}PASS${RESET}"
    pass=$((pass+1))
  else
    echo -e "${RED}FAIL${RESET}"
    fail=$((fail+1))
  fi
done

line
printf "%bTOTAL:%b %02d  |  %bPASS:%b %02d  |  %bFAIL:%b %02d  |  %bSKIP:%b %02d\n" \
  "$BLUE$BOLD" "$RESET" "$total" \
  "$GREEN$BOLD" "$RESET" "$pass" \
  "$RED$BOLD" "$RESET" "$fail" \
  "$YELLOW$BOLD" "$RESET" "$skip"
line

rm -f "$EXECUTABLE"

[ "$fail" -eq 0 ] || exit 1
exit 0
